const express = require('express');
const router = express.Router();
const { getUsers, getRoles, createUser, updateUser, deleteUser, toggleUserStatus, getAuditLogs } = require('../controllers/userController');
const { authenticateToken, authorizeRole } = require('../middleware/authMiddleware');

// All routes require admin access
router.use(authenticateToken);
router.use(authorizeRole(['admin']));

router.get('/', getUsers);
router.get('/roles', getRoles);
router.post('/', createUser);
router.put('/:id', updateUser);
router.delete('/:id', deleteUser);
router.put('/:id/status', toggleUserStatus);
router.get('/audit-logs', getAuditLogs);

module.exports = router;
