const { pool } = require('../config/db');

const migrate = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');
    
    // Add details column to registrations table
    await client.query(`
      ALTER TABLE registrations 
      ADD COLUMN IF NOT EXISTS details JSONB DEFAULT '{}';
    `);

    await client.query('COMMIT');
    console.log('Migration successful: Added details to registrations table');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Migration failed', e);
  } finally {
    client.release();
    pool.end();
  }
};

migrate();
