const path = require('path');
require('dotenv').config({ path: path.resolve(__dirname, '../../.env') });
const db = require('../config/db');

async function checkComments() {
  try {
    const result = await db.query(`
      SELECT 
        p.id, 
        p.title, 
        (SELECT COUNT(*)::int FROM comments c WHERE c.post_id = p.id) as comments_count
      FROM posts p
    `);
    console.log('Posts and comment counts:', result.rows);
  } catch (error) {
    console.error('Error:', error);
  } finally {
    process.exit();
  }
}

checkComments();
