const { pool } = require('../config/db');

const migrateUserManagement = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');

    // Add is_active to users
    await client.query(`
      ALTER TABLE users 
      ADD COLUMN IF NOT EXISTS is_active BOOLEAN DEFAULT TRUE;
    `);

    // Create Audit Logs table
    await client.query(`
      CREATE TABLE IF NOT EXISTS audit_logs (
        id SERIAL PRIMARY KEY,
        user_id INTEGER REFERENCES users(id) ON DELETE SET NULL,
        action VARCHAR(50) NOT NULL,
        details JSONB,
        ip_address VARCHAR(45),
        created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
      );
    `);

    await client.query('COMMIT');
    console.log('User management migration completed successfully');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Error during migration', e);
  } finally {
    client.release();
    pool.end();
  }
};

migrateUserManagement();
